/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.ammo;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.common.entity.projectile.IReaction;
import dev.toma.gunsrpg.common.item.guns.ammo.ReactiveMaterial;
import dev.toma.gunsrpg.common.item.guns.ammo.SimpleMaterial;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public final class AmmoMaterialManager {
    private static final AmmoMaterialManager INSTANCE = new AmmoMaterialManager();
    private final Map<ResourceLocation, IAmmoMaterial> materialMap = new HashMap<ResourceLocation, IAmmoMaterial>();

    public static AmmoMaterialManager get() {
        return INSTANCE;
    }

    public IAmmoMaterial parse(CompoundNBT nbt) {
        String stringMaterialID = nbt.func_74779_i("material");
        if (stringMaterialID.isEmpty()) {
            return null;
        }
        ResourceLocation materialID = new ResourceLocation(stringMaterialID);
        return this.findMaterial(materialID);
    }

    public IAmmoMaterial findMaterial(ResourceLocation location) {
        return this.materialMap.get(location);
    }

    public IAmmoMaterial createMaterial(ResourceLocation materialID, int textColor, int levelReq, Integer tracer) {
        return this.createMaterial(new SimpleMaterial(materialID, textColor, levelReq, tracer));
    }

    public IAmmoMaterial createMaterial(String name, int textColor, int levelReq, Integer tracer) {
        return this.createMaterial(GunsRPG.makeResource(name), textColor, levelReq, tracer);
    }

    public IAmmoMaterial createMaterial(ResourceLocation materialID, int textColor, int levelReq) {
        return this.createMaterial(materialID, textColor, levelReq, null);
    }

    public IAmmoMaterial createMaterial(String name, int textColor, int levelReq) {
        return this.createMaterial(name, textColor, levelReq, null);
    }

    public IAmmoMaterial createReactiveMaterial(ResourceLocation materialID, int textColor, int levelReq, IReaction reaction) {
        return this.createMaterial(new ReactiveMaterial(materialID, textColor, levelReq, reaction));
    }

    public IAmmoMaterial createReactiveMaterial(String name, int textColor, int levelReq, IReaction reaction) {
        return this.createReactiveMaterial(GunsRPG.makeResource(name), textColor, levelReq, reaction);
    }

    public IAmmoMaterial createMaterial(IAmmoMaterial material) {
        this.materialMap.put(material.getMaterialID(), material);
        return material;
    }
}

